/* @(#) somx/dired.c 2.3 1/20/94 10:09:15 [5/15/94 17:58:49] */

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */

#define dirED_Class_Source
#include <dired.ih>

#include <somp.h>
#include <phonedir.ih>
#include <direntry.ih>

/*
 *========================================================================
 * Operation:  ED Write
 * Write out a phoneDir object.
 *========================================================================
 */

SOM_Scope void  SOMLINK sompEDWrite(dirED somSelf,  Environment *ev,
                                    SOMPMediaInterfaceAbstract thisMedia,
                                    SOMPPersistentObject thisObject)
{
/* Local declarations.
   ------------------- */
    long dlen;
    int i;
    _IDL_SEQUENCE_dirEntry directory;

    /* dirEDData *somThis = dirEDGetData(somSelf); */
    dirEDMethodDebug("dirED","sompEDWrite");

/* Write out sequence max
   ---------------------------- */
    directory = __get_directory(thisObject);
    _sompWriteLong(thisMedia, ev, directory._maximum);

/* Write out number of entries.
   ---------------------------- */
    dlen = directory._length;
    _sompWriteLong(thisMedia, ev, dlen);

/* Write the children objects of this object.
   A call to sompWriteSomobject will result in a
   child object being stored if "thisObject" was
   stored with sompStoreObject.
   -------------------------------------------- */
    for (i=0;(i < dlen) && (ev->_major == NO_EXCEPTION);i++) {
       _sompWriteSomobject(thisMedia, ev, directory._buffer[i], thisObject);
    } /* endfor */

    return;
}

/*
 *========================================================================
 * Operation:  ED Read
 * Read in a phoneDir object.
 *========================================================================
 */

SOM_Scope void  SOMLINK sompEDRead(dirED somSelf,  Environment *ev,
                                   SOMPMediaInterfaceAbstract thisMedia,
                                   SOMPPersistentObject thisObject)
{
/* Local Declarations.
   ------------------- */
    int i;
    long dlen, dmax;
    SOMObject ro;
    _IDL_SEQUENCE_dirEntry directory;

    /* dirEDData *somThis = dirEDGetData(somSelf); */
    dirEDMethodDebug("dirED","sompEDRead");

    /* Read in max size of directory sequence */
    _sompReadLong(thisMedia, ev, &dmax);
    directory._maximum = dmax;
    /* Read in actual length of directory sequence */
    _sompReadLong(thisMedia, ev, &dlen);
    directory._length = dlen;

    if (ev->_major == NO_EXCEPTION) {
       /* allocate a sequence buffer to accomodate maximum */
       directory._buffer = (dirEntry *)SOMMalloc(dmax*sizeof(dirEntry));

       /* Restore persistent objects into the entries of the sequence.
          ------------------------------------------------------------ */
       for (i=0;i < dlen && (ev->_major == NO_EXCEPTION);i++) {
          /* The object read, ro, is an unstable instance of
             the requested object. This means it exists but
             has not been completely read from storage yet.
             sompReadSomobject adds the new object, ro, to
             its list of objects to restore.               */
          _sompReadSomobject(thisMedia, ev, (SOMObject*)(&ro));
          *(directory._buffer + i) = ro;
       } /* endfor */
       if (ev->_major == NO_EXCEPTION) {
          __set_directory(thisObject, &directory); /* copies the structure */
       }
    }

    return;
}

